USE AdventureWorks2014;
GO
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
GO

IF EXISTS (SELECT * FROM sys.objects WHERE objects.name = 'Java_Hashcode' AND objects.type = 'FN')
BEGIN
	DROP FUNCTION dbo.Java_Hashcode;
END
GO

CREATE FUNCTION dbo.Java_Hashcode
	(@Input_String_List VARCHAR(MAX)) -- This is a CSV of any number of strings
RETURNS BIGINT
AS
BEGIN
	DECLARE @Input_Strings TABLE
		(Input_String VARCHAR(MAX));

	INSERT INTO @Input_Strings
		(Input_String)
	SELECT
		*
	FROM STRING_SPLIT(@Input_String_List, ',');

	DECLARE @Java_Hashcode_Output BIGINT;
	DECLARE @Java_Hashcode_Output_Total BIGINT = 0;
	DECLARE @Character_Counter BIGINT;
	DECLARE @Input_String_Length BIGINT;
	DECLARE @Current_Character VARCHAR(1);
	DECLARE @Current_Character_Ascii_Value SMALLINT;
	DECLARE @Prime_Number BIGINT = 31;
	DECLARE @Current_String VARCHAR(MAX);

	DECLARE String_Cursor CURSOR FOR
		SELECT Input_String FROM @Input_Strings;
	OPEN String_Cursor;
	FETCH NEXT FROM String_Cursor INTO @Current_String;

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT @Input_String_Length = LEN(@Current_String);
		SELECT @Character_Counter = 1
		SELECT @Java_Hashcode_Output = 0;

		WHILE @Character_Counter <= @Input_String_Length
		BEGIN
			SELECT @Current_Character = SUBSTRING(@Current_String, @Character_Counter, 1);
			SELECT @Current_Character_Ascii_Value = ASCII(@Current_Character);

			SELECT @Java_Hashcode_Output = (@Java_Hashcode_Output * @Prime_Number + @Current_Character_Ascii_Value) % POWER(CAST(2 AS BIGINT), 32);

			SELECT @Character_Counter = @Character_Counter + 1;
		END

		IF @Java_Hashcode_Output >= POWER(CAST(2 AS BIGINT), 31)
		BEGIN
			SELECT @Java_Hashcode_Output = @Java_Hashcode_Output - POWER(CAST(2 AS BIGINT), 32)
		END
		ELSE
		IF @Java_Hashcode_Output <= -1 * POWER(CAST(2 AS BIGINT), 31)
		BEGIN
			SELECT @Java_Hashcode_Output = @Java_Hashcode_Output + POWER(CAST(2 AS BIGINT), 32)
		END

		SELECT @Java_Hashcode_Output_Total = @Java_Hashcode_Output_Total + @Java_Hashcode_Output;
		
		IF @Java_Hashcode_Output_Total >= POWER(CAST(2 AS BIGINT), 31)
		BEGIN
			SELECT @Java_Hashcode_Output_Total = @Java_Hashcode_Output_Total - POWER(CAST(2 AS BIGINT), 32)
		END
		ELSE
		IF @Java_Hashcode_Output_Total <= -1 * POWER(CAST(2 AS BIGINT), 31)
		BEGIN
			SELECT @Java_Hashcode_Output_Total = @Java_Hashcode_Output_Total + POWER(CAST(2 AS BIGINT), 32)
		END

		FETCH NEXT FROM String_Cursor INTO @Current_String;
	END

	CLOSE String_Cursor;
	DEALLOCATE String_Cursor;

	RETURN @Java_Hashcode_Output_Total;
END
GO